### Summary of 802.1X Deployment and Configuration

This summary outlines a phased approach and key configuration steps for deploying 802.1X on Cisco Catalyst switches, ensuring a seamless transition to identity-based policy services. The document is categorized into phases, deployment modes, fallback options, host modes, flexible authentication, timers, and detailed configuration steps.

---

### **Phased Deployment of 802.1X**

#### Benefits of a Phased Approach:

- Gradual policy enforcement to minimize impact.
- Improved visibility into network behavior.
- Adjustment of policies over time for smoother transitions.

#### 802.1X Deployment Modes:

1. **Monitor (Open) Mode:**
    
    - Enables authentication without affecting access.
    - Used for auditing and logging device behavior.
    - Allows visibility into connected devices and their authentication success.
2. **Low-Impact Mode:**
    
    - Provides selective preauthorization using pre-authentication ACLs.
    - Permits essential services (e.g., DHCP, DNS) while blocking others until authentication.
3. **High-Security (Closed) Mode:**
    
    - Strict control with no traffic allowed before authentication.
    - Default behavior for 802.1X-enabled ports.

---

### **802.1X Fallback Options**

Fallback mechanisms are essential for non-802.1X capable devices:

- **MAC Authentication Bypass (MAB):** Uses the MAC address for authentication. Commonly used for devices like printers and cameras.
- **Guest VLAN:** Provides limited access for unauthenticated devices.
- **Authentication Fail VLAN:** Similar to Guest VLAN but triggered by failed authentication.
- **Central Web Authentication (CWA):** Allows redirection to a web portal for authentication.

---

### **802.1X Host Modes**

Defines how multiple devices are authenticated on a single port:

1. **Single Host Mode:** Only one client is authenticated; additional clients are denied.
2. **Multiple Host Mode:** Authenticates the first client; subsequent clients share access.
3. **Multiple Domain Authentication (MDA):** Separates voice and data VLAN authentication.
4. **Multiple Authentication Mode:** Authenticates each connected client individually.

---

### **Flexible Authentication (FlexAuth)**

- Allows a sequence of authentication methods (e.g., 802.1X, MAB, and web authentication).
- Simplifies configuration by enabling fallback mechanisms.
- Recommended order: 802.1X first, followed by MAB.

---

### **Inaccessible Authentication Bypass (Critical VLAN)**

- Provides limited network access when the RADIUS server is unavailable.
- Moves devices to a critical VLAN for basic connectivity.
- Automatically reinitializes ports when the RADIUS server becomes reachable.

---

### **802.1X Timers**

Timers control the timing of 802.1X authentication:

- **Key Variables:**
    - `tx-period`: Time between EAP request retransmissions.
    - `max-reauth-req`: Number of retries before timing out.
- **Formula:**
    - Timeout = `\(max-reauth-req + 1\) * tx-period`
- **Recommendations:**
    - Shorter timers for faster MAB fallback.
    - Longer timers to ensure 802.1X authentication for capable devices.

---

### **Configuration Steps**

#### 1. **Global AAA Settings**

- Enable AAA and configure 802.1X:
    
    
    ```bash
    aaa new-model
    aaa authentication dot1x default group ISE
    aaa authorization network default group ISE
    aaa accounting dot1x default start-stop group ISE
    ```
    

#### 2. **Global RADIUS Settings**

- Configure the RADIUS server and dead-server detection:
    
    
    ```bash
    radius server ISE
     address ipv4 10.64.0.100 auth-port 1812 acct-port 1813
     automate-tester username dummy ignore-acct-port
     key 3df23d21
    radius-server dead-criteria time 5 tries 3
    radius-server deadtime 3
    ```
    

#### 3. **RADIUS Server Group and CoA**

- Create a RADIUS server group and enable Change of Authorization (CoA):
    
    
    ```bash
    aaa group server radius ISE
     server name ISE
    aaa server radius dynamic-author
     client 10.64.0.100 server-key 3df23d21
    ```
    

#### 4. **Enable SISF-Based Device Tracking**

- Enable device tracking for accurate endpoint identification:
    
    
    ```bash
    interface GigabitEthernet1/0/1
     device-tracking
    ```
    

#### 5. **Enable 802.1X Globally**

- Activate 802.1X system-wide:
    
    
    ```bash
    dot1x system-auth-control
    ```
    

#### 6. **Interface-Specific Settings**

- Configure access ports for 802.1X:
    
    ```bash
    interface GigabitEthernet1/0/1
     switchport mode access
     switchport access vlan 10
     spanning-tree portfast
     ip access-group PRE-AUTH in
     authentication open
     authentication port-control auto
     authentication periodic
     authentication timer reauthenticate server
    ```
    

#### 7. **Support for IP Phones**

- Enable MDA and configure FlexAuth:
    
    
    ```bash
    interface GigabitEthernet1/0/1
     switchport voice vlan 40
     authentication host-mode multi-domain
     mab
     authentication order dot1x mab
     authentication priority dot1x mab
     authentication event fail action next-method
    ```
    

#### 8. **Critical VLAN Configuration**

- Configure critical VLAN for fallback:
    
    
    ```bash
    interface GigabitEthernet1/0/1
     authentication event server dead action authorize vlan 88
     authentication event server dead action authorize voice
     authentication event server alive action reinitialize
    ```
    

---

### **Key Notes**

- Test 802.1X timers and fallback mechanisms in a lab environment before deployment.
- Use ACLs to permit basic services during authentication in low-impact mode.
- Consider network-specific requirements for optimal timer and fallback configurations.